package editor;

import game.BusyPanel;
import game.PonyPanel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.ServerSocket;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StartupPanel extends JPanel {
	
	
	public StartupPanel() {
		
		super();
		
		
		
		JPanel mainPanel = new JPanel(new GridLayout(1, 3));
		
		JButton editorButton = new JButton("Editor");
		editorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				startEditor();
			}
		});
		JPanel editorPanel = new JPanel(new FlowLayout());
		editorPanel.add(editorButton);
		mainPanel.add(editorPanel);
		
		mainPanel.add(new JPanel());
		
		JPanel gamePanel = new JPanel(new FlowLayout());
		JButton gameButton = new JButton("Game");
		gameButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				startGame();
			}
		});
		gamePanel.add(gameButton);
		mainPanel.add(gamePanel);
		
		this.setLayout(new GridLayout(2, 1));
		
		JPanel labelPanel = new JPanel(new FlowLayout());
		JLabel label = new JLabel("<html><br><br><b>Which do you want to start up?</b></html>");
		labelPanel.add(label);
		mainPanel.add(labelPanel);
		
		this.add(labelPanel);
		
		this.add(mainPanel);
		
		
		
	}
	
	private static JFrame frame;
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		frame = new JFrame();
		
		frame.setPreferredSize(new Dimension(300, 200));
		frame.setMinimumSize(new Dimension(300, 200));
		frame.setMaximumSize(new Dimension(300, 200));
		
		StartupPanel sp = new StartupPanel();
		
		frame.setContentPane(sp);
		
		frame.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				if(frame != null) {
					frame.dispose();
				}
			}
		});
		
		frame.setVisible(true);
		
		
	}
	
	
	private void startGame() {
		
		if(frame != null) {

			frame.dispose();
		}
		
		
		String path;
		try {
			path = StartupPanel.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
			ProcessBuilder pb = new ProcessBuilder("java","-Xmx1024m", "-classpath", path, "game.PonyTestDriver");
			pb.start();
			
//			ServerSocket ss = new ServerSocket(43253);
//			
//			ss.accept();
			
			JOptionPane.showMessageDialog(null, "It sometimes takes several seconds for the game to load; please be patient.","The game is starting!", JOptionPane.INFORMATION_MESSAGE);
			
			
		} catch (Exception e) {
			String traceRaw = PonyPanel.formatStackTrace(e);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred while trying to start the game:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}
		
		
//		PonyTestDriver.main(null);
		
	}
	
	private void startEditor() {
		
		if(frame != null)
			frame.dispose();
		
		String path;
		try {
			path = StartupPanel.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
			ProcessBuilder pb = new ProcessBuilder("java","-Xmx1024m", "-classpath", path, "editor.MainEditorPanel");
			pb.start();
		} catch (Exception e) {
			String traceRaw = PonyPanel.formatStackTrace(e);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred while trying to start the editor:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}//MainEditorPanel.main(null);
		
	}

}
